///////////////////////////////////////////////////////////////////////////////
//                                                                           
// (C) Copyright 2001 by Autodesk, Inc. 
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted, 
// provided that the above copyright notice appears in all copies and 
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting 
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC. 
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to 
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//
// CREATED BY:
//	Valentin Ofshteyn, June 2001
//
// DESCRIPTION:
// AttrPosEnabler.h: interface for the AttrPosEnabler class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ATTRPOSENABLER_H__11FDDADA_59E4_11D5_96E1_0010B56FA9A3__INCLUDED_)
#define AFX_ATTRPOSENABLER_H__11FDDADA_59E4_11D5_96E1_0010B56FA9A3__INCLUDED_

#pragma once

#include "AcMapOracleReactor.h"
#include "dbid.h"
#include "gepnt3d.h"
#include <map>

class AttrPosEnabler;
class AcDbAttribute;

class MyConnectionReactor: public AcMapOracleConnectionReactor
{
public:
	MyConnectionReactor(AttrPosEnabler *pEnabler);
	virtual ~MyConnectionReactor();

	virtual void Disconnected();
private:
	AttrPosEnabler *m_pEnabler;
};

class MyImportReactor: public AcMapOracleImportReactor
{
public:
	MyImportReactor(AttrPosEnabler *pEnabler);
	virtual ~MyImportReactor();

	virtual void RecordImported(const ODynaset &Dynaset, AcDbEntity *pAcDbEntity);
	virtual void RecordRejected(const ODynaset &Dynaset);
private:
	AttrPosEnabler *m_pEnabler;
};

class MyExportReactor: public AcMapOracleExportReactor
{
public:
	MyExportReactor(AttrPosEnabler *pEnabler);
	virtual ~MyExportReactor();

	virtual void ObjectCached(AcDbEntity *pObj, unsigned long lOracleID);
	virtual void ObjectsExported(std::vector<unsigned long> &vOracleIDs);
private:
	AttrPosEnabler *m_pEnabler;
};

class AttrPosEnabler  
{
public:
	AttrPosEnabler(AcMapOracleConnection *pConnection);
	virtual ~AttrPosEnabler();

	void AddBlockReferenceToCache(AcDbBlockReference *pBlockRef, unsigned long lOracleID);
	void ExportAttributePositions(std::vector<unsigned long> &vOracleIDs);
	void AddBlockIDToCache(AcDbObjectId id);
	void CorrectAttributePositions();

private:
	//typedefs
	typedef std::map<unsigned long, AcDbObjectId> MapBlocks;
	typedef std::multimap<unsigned long, AcGePoint3d> MapPositions;
	typedef std::vector<AcDbObjectId> VBlocksIds;
	typedef std::vector< std::pair<unsigned long, AcDbObjectId> > VBlockCash;

	//data
	MyImportReactor *		m_pImportReactor;
	MyExportReactor *		m_pExportReactor;
	MyConnectionReactor *	m_pConnectionReactor;
	AcMapOracleConnection *	m_pConnection;
	OParamArray				m_oParamPos[4];
	MapBlocks				m_map;
	VBlockCash				m_CorrectCash;
	MapPositions			m_mapPos;
	VBlocksIds				m_vBlockID;
	OParameterCollection	m_clollParams;
	static const char*		sm_kpcParamNames[4];
	static const int		sm_nParamTypes[4];
	
	//methods
	void CasheAttributePosition(const AcDbAttribute *pAttrib, unsigned long oracleId);
	void CreateParameters(int nSize);
	void WriteCachedPositions();
	void WriteToDatabasePositions();
	void RemoveTables();
	bool IsHasAttributes(AcDbBlockReference *pBlockRef);
	void CacheOracleId(AcDbObjectId id);
	void AttributeUpdate();
	void UpdateParameters(ODynaset &ds, AcDbObjectId id);
	void UptatePosition(
		AcDbObjectId id, 
		const std::vector<AcGePoint3d> &vPos);

};

#endif // !defined(AFX_ATTRPOSENABLER_H__11FDDADA_59E4_11D5_96E1_0010B56FA9A3__INCLUDED_)
